<?php

$general = get_field('general', 'options');
$modalContacto = get_field('modal_contacto', 'options');

?>
<div id="modal-contacto" class="modal-contacto">
    <div class="contenedor-dodo">
        <img src="<?php echo theme_url(); ?>/assets/images/dodo5.svg" alt="">
    </div>
    <div class="main-container">
        <div class="contenedor-head">
            <div class="contenedor-left"></div>
            <a href="<?php echo home_url(); ?>" class="contenedor-logo">
                <img src="<?php echo theme_url(); ?>/assets/images/logoWhite.svg" alt="">
            </a>
            <div class="contenedor-right">
                <a href="#" data-modalContacto>
                    <span class="text-modal-menu-mobile">Cerrar</span>
                </a>
            </div>
        </div>
        <div class="contenedor-body">
            <div class="contenedor-left">
                <?php if ($modalContacto['titulo']) { ?>
                    <h1><?php echo $modalContacto['titulo']; ?></h1>
                <?php } ?>
                <?php if ($modalContacto['texto']) { ?>
                    <p><?php echo $modalContacto['texto']; ?></p>
                <?php } ?>
                <?php if ($modalContacto['subtitulo']) { ?>
                    <h2><?php echo $modalContacto['subtitulo']; ?></h2>
                <?php } ?>
                <?php if ($modalContacto['correo_electronico']) { ?>
                    <a href="mailto:<?php echo $modalContacto['correo_electronico']; ?>" class="p">
                        <span><?php echo $modalContacto['correo_electronico']; ?></span>
                    </a>
                <?php } ?>
                <div class="contenedor-redes-items">
                    <a target="_blank" href="<?php echo $general['redes_sociales']['facebook']; ?>" class="red"><?php smk_get_template_part('template-parts/componentsSVG/componente-facebookSVG.php'); ?></a>
                    <a target="_blank" href="<?php echo $general['redes_sociales']['instagram']; ?>" class="red"><?php smk_get_template_part('template-parts/componentsSVG/componente-instagramSVG.php'); ?></a>
                    <a target="_blank" href="<?php echo $general['redes_sociales']['tiktok']; ?>" class="red"><?php smk_get_template_part('template-parts/componentsSVG/componente-tiktokSVG.php'); ?></a>
                </div>
            </div>
            <div class="contenedor-right">
                <?php if ($modalContacto['formulario']['titulo']) { ?>
                    <h2><?php echo $modalContacto['formulario']['titulo']; ?></h2>
                <?php } ?>
                <form id="form-contacto" novalidate>
                    <div class="input">
                        <input id="asunto" name="asunto" type="text" placeholder="Asunto">
                        <span></span>
                    </div>
                    <div class="input">
                        <input id="nombre" name="nombre" type="text" placeholder="Nombre">
                        <span></span>
                    </div>
                    <div class="input">
                        <input id="correo" name="correo" type="email" placeholder="Correo">
                        <span></span>
                    </div>
                    <div class="input">
                        <input id="mensaje" name="mensaje" type="text" placeholder="Mensaje">
                        <span></span>
                    </div>
                    <button type="submit" class="btn-main" id="btnContact">
                        <img src="<?php echo theme_url(); ?>/assets/images/icon-corazon.svg" alt="">
                        <span class="text-btn-main">Enviar</span>
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
<div id="modal-menu" class="modal-menu">
    <div class="main-container">
        <div class="contenedor-menu">
            <?php
            $menu1 = wp_get_nav_menu_items('Menu 1');
            $menu2 = wp_get_nav_menu_items('Menu 2');
            ?>
            <?php if ($menu1) { ?>
                <?php foreach ((array)$menu1 as $key => $menu_item) { ?>
                    <a class="item text-modal-menu-mobile <?php echo vince_check_active_menu($menu_item) ?>" href="<?php echo $menu_item->url; ?>">
                        <span>
                            <?php echo $menu_item->title; ?>
                            <img src="<?php echo theme_url(); ?>/assets/images/hoverMenu.svg" alt="">
                        </span>
                    </a>
                <?php } ?>
            <?php } ?>
            <?php if ($menu2) { ?>
                <?php foreach ((array)$menu2 as $key => $menu_item) { ?>
                    <a class="item text-modal-menu-mobile <?php echo vince_check_active_menu($menu_item) ?>" href="<?php echo $menu_item->url; ?>">
                        <span>
                            <?php echo $menu_item->title; ?>
                            <img src="<?php echo theme_url(); ?>/assets/images/hoverMenu.svg" alt="">
                        </span>
                    </a>
                <?php } ?>
            <?php } ?>
        </div>
        <div class="contenedor-redes">
            <span class="text-menu-mobile">Sígueme</span>
            <div class="contenedor-redes-items">
                <a target="_blank" href="<?php echo $general['redes_sociales']['tiktok']; ?>" class="red"><?php smk_get_template_part('template-parts/componentsSVG/componente-tiktokSVG.php'); ?></a>
                <a target="_blank" href="<?php echo $general['redes_sociales']['instagram']; ?>" class="red"><?php smk_get_template_part('template-parts/componentsSVG/componente-instagramSVG.php'); ?></a>
                <a target="_blank" href="<?php echo $general['redes_sociales']['facebook']; ?>" class="red"><?php smk_get_template_part('template-parts/componentsSVG/componente-facebookSVG.php'); ?></a>
                <a target="_blank" href="<?php echo $general['redes_sociales']['spotify']; ?>" class="red"><?php smk_get_template_part('template-parts/componentsSVG/componente-spotifySVG.php'); ?></a>
            </div>
        </div>
    </div>
</div>
<div class="contenedor-redes-flotantes">
    <div class="contenedor-redes-items">
        <a target="_blank" href="<?php echo $general['redes_sociales']['facebook']; ?>" class="red"><?php smk_get_template_part('template-parts/componentsSVG/componente-facebookSVG.php'); ?></a>
        <a target="_blank" href="<?php echo $general['redes_sociales']['instagram']; ?>" class="red"><?php smk_get_template_part('template-parts/componentsSVG/componente-instagramSVG.php'); ?></a>
        <a target="_blank" href="<?php echo $general['redes_sociales']['tiktok']; ?>" class="red"><?php smk_get_template_part('template-parts/componentsSVG/componente-tiktokSVG.php'); ?></a>
        <a target="_blank" href="<?php echo $general['redes_sociales']['spotify']; ?>" class="red"><?php smk_get_template_part('template-parts/componentsSVG/componente-spotifySVG.php'); ?></a>
    </div>
</div>

<div class="modal-tallas">
    <div class="container-content">
        <a href="#" class="btnCerrar openModalTallas">cerrar</a>
        <div class="container-tallas">
            <?php
            $listallas = get_field('lista_de_tallas', 'option');
            if (!empty($listallas)) {
                foreach ($listallas as $tallas) {
            ?>
                    <div class="container-t">
                        <?php
                        if ($tallas['titulo']) {
                        ?>
                            <h4><?php echo $tallas['titulo']; ?></h4>
                        <?php } ?>
                        <?php
                        $img = $tallas['imagen']['url'];
                        $imgMovil = $tallas['imagen_movil']['url'];
                        ?>
                        <div class="container-imgs">
                            <img class="img-desk" src="<?php echo $img; ?>" alt="">
                            <img class="img-movil" src="<?php echo $imgMovil; ?>" alt="">
                        </div>
                    </div>
            <?php
                }
            } ?>
        </div>
    </div>
    <div class="plasta openModalTallas"></div>
</div>
<div id="modal-video-acercaDe" class="modal-video-acercaDe">
    <div class="contenedor-video-acercaDe">
        <div class="modal-video-acercaDe-child"></div>
        <div class="close" data-video-modal-close></div>
    </div>
</div>