<?php
include_once(ABSPATH . 'wp-admin/includes/plugin.php');
include_once(__DIR__ . '/helpers/EYHelper.php');
include_once(__DIR__ . '/lib/index.php');
// init enviaya

const PREFIX = 'enviaya';

function enviaya_shipping_init(){
    $settings = EYHelper::settings();

    $excludedZone = false;
    if (!class_exists( 'Enviaya_Shipping_Method')) 
    {
        if (isset($_POST['down_label'])) {
            global $wpdb;

            $order = get_post();

            if (isset($settings['origin_address']->country_code) && isset($settings['origin_address']->postal_code)) {
                $props = [
                    'get_post'     => $order,
                    'wc_get_order' => wc_get_order(),
                ];
                //Snippet for build shipment
                $result    = EYHelper::libAPI()->create(EYHelper::create_shipment($props));
                $response2 = $result['response'];

                error_log("NEW ORDER 1 REQUEST: " . json_encode($result['request']));
                error_log("NEW ORDER 1 RESPONSE: " . json_encode($response2));


                $states_rate = $wpdb->get_results(
                    "SELECT * FROM {$wpdb->prefix}" . PREFIX . "_rates WHERE order_id = {$order->ID} AND
                        carrier_service_code = '{$result['request']['carrier_service_code']}' AND
                        carrier = '{$result['request']['carrier']}';"
                );

                $rate_id = $states_rate[0]->rate_id;
                $states0 = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}" . PREFIX . "_rates WHERE
                            order_id = {$order->ID} AND rate_id = {$rate_id};");

                if (
                    isset($states0[0]) && isset($response2->enviaya_shipment_number)
                    && isset($response2->carrier_shipment_number)
                ) {
                    $wpdb->query("INSERT INTO {$wpdb->prefix}" . PREFIX . "_shipment (
                        rate_id, order_id, carrier, carrier_logo_url, estimated_delivery, carrier_service_name,
                        carrier_service_code, total_amount, net_total_amount, currency, enviaya_shipment_number,
                        carrier_shipment_number, label_url, shipment_status, webhook_status
                        ) VALUES (
                            '{$rate_id}', '{$order->ID}', '{$states0[0]->carrier}', '{$states0[0]->carrier_logo_url}',
                            '{$states0[0]->estimated_delivery}', '{$states0[0]->carrier_service_name}',
                            '{$states0[0]->carrier_service_code}', '{$states0[0]->total_amount}',
                            '{$states0[0]->net_total_amount}', '{$states0[0]->currency}',
                            '{$response2->enviaya_shipment_number}', '{$response2->carrier_shipment_number}',
                            '{$response2->label_share_link}', 'Waiting', 'empty' )");
                }
            }

            header("refresh:0;");
        }//end down_label

        if (isset($_POST['ship'])) {
            global $wpdb;

            $props = [
                'get_post'     => get_post(),
                'wc_get_order' => wc_get_order(),
                'rate_id'      => $_COOKIE['rate_id']
            ];

            $result = EYHelper::libAPI()->create(EYHelper::create_shipment($props));
            $response2 = $result['response'];

            error_log("NEW ORDER 2 REQUEST: " . json_encode($result['request']));
            error_log("NEW ORDER 2 RESPONSE: " . json_encode($response2));

            $states0 = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}" . PREFIX . "_rates WHERE
                        order_id = {$order->ID} AND rate_id = {$rate_id};");

            if (
                isset($states0[0]) && isset($response2->enviaya_shipment_number)
                && isset($response2->carrier_shipment_number)
            ) {
                $wpdb->query("INSERT INTO {$wpdb->prefix}" . PREFIX . "_shipment (
                    rate_id, order_id, carrier, carrier_logo_url, estimated_delivery, carrier_service_name,
                    carrier_service_code, total_amount, net_total_amount, currency, enviaya_shipment_number,
                    carrier_shipment_number, label_url, shipment_status, webhook_status
                    ) VALUES (
                        '{$rate_id}', '{$order->ID}', '{$states0[0]->carrier}', '{$states0[0]->carrier_logo_url}',
                        '{$states0[0]->estimated_delivery}', '{$states0[0]->carrier_service_name}',
                        '{$states0[0]->carrier_service_code}', '{$states0[0]->total_amount}',
                        '{$states0[0]->net_total_amount}', '{$states0[0]->currency}',
                        '{$response2->enviaya_shipment_number}', '{$response2->carrier_shipment_number}',
                        '{$response2->label_share_link}', 'Waiting', 'empty' )");
            }

            header("refresh:0;");
        }//end ship

        require_once __DIR__.'/shipping/Enviaya_Shipping_Method.php';

        do_action('enviaya_shipping_rates_updated');
        add_action('woocommerce_new_order_item', 'enviaya_new_order',  1, 3);

        function enviaya_new_order($item_id, $item, $order_id)
        {
            $settings = EYHelper::settings();

            if (!empty($item->get_meta('carrier_service_name')) && !empty($item->get_meta('carrier_name'))) {
                $order          = wc_get_order($order_id);
                $shipping       = $order->get_data();
                $origin_address = $settings['origin_address'];
                $parcels        = EYHelper::buildPackage($order_id);

                $total = WC()->cart->subtotal;
                $order_total_amount = isset($settings['enable_currency_support']) &&
                    $settings['enable_currency_support'] === 'yes' ?
                    apply_filters('raw_woocommerce_price', floatval($total < 0 ? $total * -1 : $total)) : $total;
                $currency = isset($settings['enable_currency_support']) &&
                    $settings['enable_currency_support'] === 'yes' ? get_woocommerce_currency() : (isset($settings['default_currency']) && $settings['default_currency'] ?
                        $settings['default_currency'] : get_woocommerce_currency());

                $props = [
                    'rate_currency'             => $currency,
                    'shipment_type'             => 'Package',
                    'parcels'                   => $parcels,
                    'origin_country_code'       => isset($origin_address) ? $origin_address->country_code : null,
                    'origin_postal_code'        => isset($origin_address) ? $origin_address->postal_code : null,
                    'origin_state_code'         => isset($origin_address) ? $origin_address->state_code : null,
                    'destination_country_code'  => $shipping['shipping']['country'],
                    'destination_postal_code'   => $shipping['shipping']['postcode'],
                    'destination_state_code'    => $shipping['shipping']['state'],
                    'insured_value_currency'    => $currency,
                    'currency'                  => $currency,
                    'order_total_amount'        => (float)$order_total_amount,
                    'locale'                    => get_user_locale()
                ];

                // $result = EYHelper::libAPI()->calculate($props);

                /* if ($settings['enable_rating'] == '1') {
                    $response = $result['response'];
                } else {
                    $response = null;
                }

                logAPI(json_encode($result['request']), 'rating_request');
                error_log("RATES REQUEST: " . json_encode($result['request']));

                logAPI(json_encode($response), 'rating_response');
                // error_log("RATES RESPONSE: " . json_encode($response));

                foreach ($response as $key => $value) {
                    if ($key !== 'warning') {
                        $rate_list[] = $value;
                    }
                } */
            }
        }        
    }
}


function rm_register_enviaya_meta_box() {
    global $wpdb;

    wp_register_script(
        'ey-ajax',
        plugins_url('admin/js/ajax.js', ENVIAYA_FILE),
        array('jquery'),
        '1.13'
    );
    wp_localize_script(
        'ey-ajax',
        'EnviayaAjax',
        array('ajaxurl' => admin_url('admin-ajax.php'))
    );
    wp_enqueue_script('ey-ajax');

    add_meta_box(
        'meta-box-ship',
        EYHelper::i18n('brand_name') . ' ' . EYHelper::i18n('shipments'),
        'rm_meta_box_callback_enviaya_1',
        'shop_order',
        'side',
        'high'
    );

    $order = get_post();
    $enviaya_shipment = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}" . PREFIX . "_shipment WHERE
        order_id = {$order->ID}");

    if (empty($enviaya_shipment)) {
        add_meta_box(
            'meta_box_new',
            EYHelper::i18n('brand_name') . ' ' . EYHelper::i18n('shipment'),
            'rm_meta_box_callback_enviaya_2',
            'shop_order',
            'side',
            'high'
        );
    }
}
add_action('add_meta_boxes', 'rm_register_enviaya_meta_box');


function rm_meta_box_callback_enviaya_2() {
    global $wpdb;

    $settings = EYHelper::settings();
    $order = get_post();

    $orderw = wc_get_order();
    $address = $orderw->get_address();

    $shipping_method = wc_get_order()->get_shipping_methods();
    $first_method = $shipping_method ? reset($shipping_method) : false;
    $is_ey_method = $first_method && $first_method->get_method_id() === 'enviaya';

    if (!$is_ey_method) {
        echo '<style>#order_shipping_line_items { display: table-row-group !important; }</style>';
    }

    $qry = "SELECT * FROM {$wpdb->prefix}" . PREFIX . "_rates
            WHERE order_id = {$order->ID}";
    $states3 = $wpdb->get_results($qry);

    if (!count($states3)) {


        $origin_address = $settings['origin_address'];

        //USE DOKAN
        if($settings['doken_integration'] === "yes"){

          $vendor_id = get_post_meta( $order->ID, '_dokan_vendor_id', true );
          $dokan_enviaya_use = get_user_meta($vendor_id, 'dokan_enviaya_use', true);

          if( !is_super_admin($vendor_id) &&  (int) $dokan_enviaya_use === 1 ){


            $dokan = [
              'api_key' => (int)get_user_meta($vendor_id, 'dokan_enviaya_enabled_test_mode', true) === 1 ? get_user_meta($vendor_id, 'dokan_enviaya_api_key_test', true) : get_user_meta($vendor_id, 'dokan_enviaya_api_key_production', true),
              'account' => get_user_meta($vendor_id, 'dokan_enviaya_account', true),
              'timeout' => get_user_meta($vendor_id, 'dokan_enviaya_timeout', true)
            ];

            $origin_address = json_decode(base64_decode(get_user_meta($vendor_id, 'dokan_sender_address', true)));

          }

        }


        $parcels = EYHelper::buildPackage($order->ID);

        $currency = isset($settings['enable_currency_support']) &&
            $settings['enable_currency_support'] === 'yes' ? get_woocommerce_currency() : (isset($settings['default_currency']) && $settings['default_currency'] ?
                $settings['default_currency'] : get_woocommerce_currency());


        $props = [
            'rate_currency'             => $currency,
            'shipment_type'             => 'Package',
            'parcels'                   => $parcels,
            'origin_country_code'       => isset($origin_address->country_code) ? $origin_address->country_code : null,
            'origin_postal_code'        => isset($origin_address->postal_code) ? $origin_address->postal_code : null,
            'origin_state_code'         => isset($origin_address->state_code) ? $origin_address->state_code : null,
            'destination_country_code'  => $orderw->get_shipping_country(),
            'destination_postal_code'   => $orderw->get_shipping_postcode(),
            'destination_state_code'    => $orderw->get_shipping_state(),
            'insured_value_currency'    => $currency,
            'currency'                  => $currency,
            'locale'                    => get_user_locale(),
        ];

        if ($settings['enable_rating'] == '1') {

            if(isset($dokan)){
              $response = EYHelper::libAPIdokan($dokan)->calculate($props)['response'];

            }else{
              $response = EYHelper::libAPI()->calculate($props)['response'];
            }

        } else {
            $response = null;
        }

        // error_log("RATES RESPONSE:" . json_encode($response));

        if ($response) {
            $rate_list = array();
            foreach ($response as $key => $value) {
                if ($key === 'store_pickup') {
                    $rate_list[] = $value;
                }

                if ($key !== 'warning' && $key !== 'errors' && $key = 'store_pickup') {
                    foreach ($value as $resp) {
                        $rate_list[] = $resp;
                    }
                }
            }

            foreach ($rate_list as $key => $resp) {
                if (isset($resp->rate_id)) {
                    $wpdb->get_results("INSERT INTO {$wpdb->prefix}" . PREFIX . "_rates (order_id, rate_id,
                        shipment_id, carrier, carrier_service_name, carrier_service_code, estimated_delivery, currency,
                        carrier_logo_url, total_amount, net_total_amount, dynamic_service_name, label_rates) VALUES
                        (" . $order->ID . ", " . $resp->rate_id . ", " . $resp->shipment_id . ", '" . $resp->carrier . "',
                        '" . $resp->carrier_service_name . "', '" . $resp->carrier_service_code . "',
                        '" . $resp->estimated_delivery . "', '" . $resp->currency . "', '" . $resp->carrier_logo_url . "',
                        '" . $resp->total_amount . "', '" . $resp->net_total_amount . "', '" . $resp->dynamic_service_name . "',
                        '');");
                    // error_log("INSERT INTO RATES :" . json_encode($qry));
                }
            }
        }
    }

    $states3 = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}" . PREFIX . "_rates
            WHERE order_id = {$order->ID}");

    $states = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}woocommerce_order_items
            WHERE order_id = {$order->ID} AND order_item_type = 'shipping'");

    $customer_selected = $states[0]->order_item_name;

    $states = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}woocommerce_order_itemmeta
            WHERE order_item_id = {$states[0]->order_item_id}");

    $carrier_service_code = '';
    $carrier_name = '';

    foreach ($states as $value) {
        if ($value->meta_key == 'carrier_name') {
            $carrier_name = $value->meta_value;
        }

        if ($value->meta_key == 'carrier_service_code') {
            $carrier_service_code = $value->meta_value;
        }
    }

    $option = '';

    if (count($states3)) {
        $states_rate = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}" . PREFIX . "_rates WHERE
            order_id = {$order->ID} AND carrier_service_code = '{$carrier_service_code}' AND
            carrier = '{$carrier_name}';");

        if (!isset($states_rate[0]->rate_id)) {
            if (isset($_COOKIE['rate_id']))
                $rate_id = $_COOKIE['rate_id'];
            else
                $rate_id = 0;
        } else {
            $rate_id = (int)$states_rate[0]->rate_id;
        }

        foreach ($states as $val) {
            $list[$val->meta_key] = $val->meta_value;
        }

        $states = $wpdb->get_results("SELECT rate_id FROM {$wpdb->prefix}" . PREFIX . "_shipment
                WHERE order_id = {$order->ID} ORDER BY id DESC LIMIT 1;");

        if (count($states) == 0) {
            foreach ($states3 as $state) {
                setcookie('rate_id', $rate_id, time() + (86400 * 999), "/");

                //Functionalty for make notes with information from shipping book,
                // snippet for hardcode selected option
                if ($rate_id == $state->rate_id) {
                    $order = wc_get_order(get_post());
                    $get_order_notes = wc_get_order_notes(['order_id' => $order->get_id(), 'type' => 'customer']);
                    if (!$get_order_notes) {
                        if (isset($state->carrier) && isset($state->carrier_service_name) && isset($state->carrier_service_code) && isset($rate_id) && isset($state->shipment_id)) {
                            $note = __("carrier={$state->carrier}; carrier_service_name={$state->carrier_service_name};
                            carrier_service_code={$state->carrier_service_code}; rate_id={$rate_id};
                            shipment_id={$state->shipment_id};");

                            //Add meta data in order
                            add_post_meta( $order->get_id(), "eya_carrier", $state->carrier );
                            add_post_meta( $order->get_id(), "eya_carrier_service_name", $state->carrier_service_name );
                            add_post_meta( $order->get_id(), "eya_carrier_service_code", $state->carrier_service_code );
                            add_post_meta( $order->get_id(), "eya_rate_id", $rate_id );
                            add_post_meta( $order->get_id(), "eya_shipment_id", $state->shipment_id );

                            //Add meta data to shipment
                            $itemsOrder  = (array) $order->get_items('shipping');
                            // Loop through shipping items
                            foreach ( $itemsOrder as $item ) {
                                $item->add_meta_data( "eya_shipment_id", $state->shipment_id, true );
                                $item->save();
                            }
                            //$order->calculate_totals();

                        } else {
                            $note = __('error while creating order comment');
                        }
                        $order->add_order_note($note, $added_by_user = true);
                    }
                    $option .= "<option selected=selected ";
                } else {
                    $option .= "<option ";
                }

                $_price = $state->total_amount;

                if ($state->carrier_service_name == "Free Shipping" || $state->carrier_service_name == "Recolección en tienda" || $state->carrier_service_name == "Store Pickup" ||  $state->carrier_service_name ==  "Abholung im Shop")
                    $option .= "rate_id='{$state->rate_id}' carrier='{$state->carrier}'
                        carrier_logo='{$state->carrier_logo_url}' estimated_delivery='{$state->estimated_delivery}'
                        carrier_service_name='{$state->carrier_service_name}'
                        carrier_service_code='{$state->carrier_service_code}'>{$state->carrier_service_name}</option>";
                else
                    $option .= "rate_id='{$state->rate_id}' carrier='{$state->carrier}'
                        carrier_logo='{$state->carrier_logo_url}' estimated_delivery='{$state->estimated_delivery}'
                        carrier_service_name='{$state->carrier_service_name}'
                        carrier_service_code='{$state->carrier_service_code}'>{$state->carrier}
                        {$state->carrier_service_name} ({$_price} {$state->currency})</option>";
            }
        } else {
            foreach ($states3 as $state) {

                // snippet for hardcode selected option
                if (isset($states[0])) {
                    setcookie('rate_id', $states[0]->rate_id, time() + (86400 * 999), "/");
                    // error_log("FREE SHIPPING : ". $states[0]->rate_id);
                    if ($states[0]->rate_id === $state->rate_id) {
                        $option .= "<option selected=selected ";
                    } else {
                        $option .= "<option ";
                    }
                } else {
                    $option .= "<option ";
                    // error_log("FREE SHIPPING : ". $states3[0]->rate_id);
                    setcookie('rate_id', $states3[0]->rate_id, time() + (86400 * 999), "/");
                }

                $tax = get_option('woocommerce_prices_include_tax');
                $_price = $tax == 'yes' ? $state->net_total_amount : $state->total_amount;

                // error_log("FREE SHIPPING : ". json_encode($state));
                if ($state->carrier_service_name == "Free Shipping")
                    $option .= "rate_id='{$state->rate_id}' carrier='{$state->carrier}'
                        carrier_logo='{$state->carrier_logo_url}' estimated_delivery='{$state->estimated_delivery}'
                        carrier_service_name='{$state->carrier_service_name}'
                        carrier_service_code='{$state->carrier_service_code}'>{$state->carrier_service_name}</option>";
                else
                    $option .= "rate_id='{$state->rate_id}' carrier='{$state->carrier}'
                        carrier_logo='{$state->carrier_logo_url}' estimated_delivery='{$state->estimated_delivery}'
                        carrier_service_name='{$state->carrier_service_name}'
                        carrier_service_code='{$state->carrier_service_code}'>{$state->carrier}
                        {$state->carrier_service_name} ({$_price} {$state->currency})</option>";
            }
        }
    }

    echo "<div id=loader style='width: 100%; height: 100%; position: absolute; background-image: url(/wp-content/plugins/enviaya-for-woocommerce/public/img/loader.gif); background-size: contain; background-repeat: no-repeat; background-color: #fff; opacity: 0.85; background-position: center; z-index: -1;'></div>";

    if ($option && !($carrier_name && $carrier_service_code)) {
        $title = '';
    } else {
        if (base64_decode($customer_selected) == 'Free Shipping' || base64_decode($customer_selected) == 'Express Flat Rate') {
            $carrier_header = base64_decode($customer_selected);
        } else {
            $carrier_header = $customer_selected;
        }

        if ($carrier_name && $carrier_service_code) {

            $title = "<div id=download_label>
                        <h3>" . EYHelper::i18n('purchased_service') . "</h3><span id=carrier_header >{$carrier_header}</span>
                        <form name=down_label >
                        <br><button type=button name=down_label id=down_label
                            class='button button-primary calculate-action'>" . EYHelper::i18n('download_label') . "</button>
                        </form></div>";
        } else {
            $title = "<div id=download_label><h3>" . EYHelper::i18n('purchased_service') . "</h3><span id=carrier_header>{$carrier_header}</span>
            <form name=optain_button>
            <input type=hidden id=country_code name=country_code value={$address['country']} >
            <input type=hidden id=postal_code name=postal_code value={$address['postcode']} >
            <input type=hidden id=state_code name=state_code value>
            <br><button type=button name=optain_button id=optain_button
                class='button button-primary calculate-action'>" . EYHelper::i18n('get_shipment_services') . "
            </button>
            </form></div>";
        }
    }

    if ($customer_selected == 'Free shipping') {
        $title = "<div id=download_label><h3>" . EYHelper::i18n('purchased_service') . "</h3>
                    <span id=carrier_header >{$customer_selected}</span>
                    <form name=optain_button>
                    <input type=hidden id=country_code name=country_code value={$address['country']} >
                    <input type=hidden id=postal_code name=postal_code value={$address['postcode']} >
                    <input type=hidden id=state_code name=state_code value ><br>
                    <button type=button style='display: none;' name=optain_button id=optain_button
                    class='button button-primary calculate-action'>" . EYHelper::i18n('get_shipment_services') . "
                    </button>
                    </form>
                  </div>";
    }

    $text_is_excluded = is_excluded_zone_admin() ?
        "<p style='background: #ff0000; width: 100%; display: block; color: #fff; padding: 10px 10px;
            box-sizing: border-box; text-align: center;'><b>" . EYHelper::i18n('excluded_zones') . "</b>
        </p>" : "";
    echo $text_is_excluded;

    if ($option == null) {
        echo "<script>
        function change_carrier(obj) {
            var index = obj.selectedIndex;
            var item = obj.children[index];
            var rate = item.getAttribute('rate_id');

            document.cookie =  'rate_id=' + rate;
        }
    </script>
    {$title}
    ";
    }

    if ($option != null) {
        echo '<div id="shipment_button">';

        echo "
        <h3>" . EYHelper::i18n('create_shipment') . "</h3>
        <div class=shipment_list>
            <span>" . EYHelper::i18n('shipping_service') . "</span>
            <select onchange=change_carrier(this) id=carrier_list name=carrier_list>{$option}</select>
        </div>
        <br/ >
            <div>
                <form name=ship method=post>
                    <button type=button name=ship id=ship class=button button-primary calculate-action>
                    " . EYHelper::i18n('create_shipment') . "
                    </button>
                </form>
            </div>";

        echo "</div>";
    }

    echo "<div id=optain_ship><h4>" . EYHelper::getReplacingKeyi18n('{#brand_name#}', 'brand_name', 'rating_error_no_services_found') . "</h4></div>";
}

function is_excluded_zone_admin()
{
    $settings = EYHelper::settings();

    $order = get_post();
    $order_data = new WC_Order($order->ID);
    $curZone = $order_data;

    if (!array_key_exists('excluded_zones_data', $settings)) {
        return false;
    } else if (empty(json_decode($settings['excluded_zones_data']))) {
        return false;
    }

    foreach (json_decode($settings['excluded_zones_data']) as $zone) {
        $subZone = explode(',', $zone->regions);
        $country = isset($subZone[0]) && explode(':', $subZone[0])[0] === 'country' ?
            explode(':', $subZone[0])[1] : false;
        $state = isset($subZone[1]) && explode(':', $subZone[1])[0] === 'state' ?
            explode(':', $subZone[1])[2] : false;
        $zip = explode(',', $zone->zips);

        if ((!$state && $country && $curZone->get_billing_country() === $country) || (!empty($zip) &&
            in_array($curZone->get_billing_postcode(), $zip))) {
            return true;
        }
    }

    return false;
}

function rm_meta_box_callback_enviaya_1() {
    global $wpdb;

    $settings = EYHelper::settings();
    $order = get_post();
    $id = $order->ID;
    $qry = "SELECT * FROM {$wpdb->prefix}" . PREFIX . "_shipment
            WHERE order_id = {$id} ORDER BY id DESC;";
    $states = $wpdb->get_results($qry);

    if (!count($states)) {
        echo "<h7>" . EYHelper::i18n('no_shipments') . "</h7>";
    }

    if (count($states)) {
        echo "<script>document.getElementById('meta-box-ship').style.display = 'block'; </script>";
    } else {
        echo "<script>document.getElementById('meta-box-ship').style.display = 'none'; </script>";
    }

    foreach ($states as $stat) {
        $_price = $stat->total_amount;
        $currency = (isset($stat->currency) ? $stat->currency : $settings['enable_currency_support']) === 'yes' ?
            get_woocommerce_currency() : $settings['default_currency'];
        echo "<td class=name>
            <div class=view_shipment ship_num={$stat->enviaya_shipment_number} carrier={$stat->carrier}>
                <div class='wc-order-data-row wc-order-totals-items wc-order-items-editable'>
                    <img src={$stat->carrier_logo_url} title=" . strtoupper($stat->carrier) . " class=shipmen_logo />
                    <ul data-shipment-id={$stat->enviaya_shipment_number} >
                        <small>" . EYHelper::i18n('status') . "</small>
                        <li>
                            <span id=text-entry-status>{$stat->shipment_status}</span>
                            <span class='dashicons dashicons-image-rotate refresh-shipment-status' style='width: 20px; height: 20px; font-size: 15px; margin-left: 5px; margin-top: 2px;'></span>
                        </li>

                        <small>" . EYHelper::i18n('service') . "</small>
                        <li>
                            <img class=status_image src=/wp-content/plugins/enviaya-for-woocommerce/public/img/statuses/status-1.png id=status-1 >
                            <img class=status_image src=/wp-content/plugins/enviaya-for-woocommerce/public/img/statuses/status-2.png id=status-2 >
                            <img class=status_image src=/wp-content/plugins/enviaya-for-woocommerce/public/img/statuses/status-13.png id=status-13 >
                            <img class=status_image src=/wp-content/plugins/enviaya-for-woocommerce/public/img/statuses/status-14.png id=status-14 >
                            <img class=status_image src=/wp-content/plugins/enviaya-for-woocommerce/public/img/statuses/status-40.png id=status-40 >
                            <img class=status_image src=/wp-content/plugins/enviaya-for-woocommerce/public/img/statuses/status-50.png id=status-50 >
                            <img class=status_image src=/wp-content/plugins/enviaya-for-woocommerce/public/img/statuses/status-90.png id=status-90 >
                            <span class=\"woocommerce-help-tip no-quesion\" data-tip=\"" . EYHelper::i18n('amount') . ":
                                " . $stat->net_total_amount . $currency . " <br>" . EYHelper::i18n('vat') . ":
                                " . ($stat->total_amount - $stat->net_total_amount) . $currency . " <br>" . EYHelper::i18n('total') . ":
                                " . $stat->total_amount . $currency . "\">{$stat->carrier_service_name}
                                ( {$_price} " . $currency . " )
                            </span>
                        </li>
                        <small>" . EYHelper::i18n('estimated_delivery') . "</small>
                        <li>{$stat->estimated_delivery}</li>
                        <small>" . EYHelper::i18n('brand_name') . EYHelper::i18n('shipment_number') . "</small>
                        <li>
                        <a target=_blank href=https://" . EYHelper::i18n('api_domain') . "/track?track_ref={$stat->enviaya_shipment_number}&show_events=true >{$stat->enviaya_shipment_number}</a>
                        </li>
                        <small>" . EYHelper::i18n('tracking_no') . "</small>
                        <li>
                        <a target=_blank href=https://" . EYHelper::i18n('api_domain') . "/track?track_ref={$stat->carrier_shipment_number}&show_events=true >{$stat->carrier_shipment_number}</a>
                        </li>
                        <a target=_blank href={$stat->label_url} >
                            <button type=button>" . EYHelper::i18n('download_label') . "</button>
                        </a>
                        <a target=_blank href=https://" . EYHelper::i18n('api_domain') . "/track?track_ref={$stat->enviaya_shipment_number}&show_events=true >
                            <button type=button >" . EYHelper::i18n('track_shipment') . "</button>
                        </a>
                    </ul>
                </div>
            </div>
        </td>";
    }
}

/* add_action('woocommerce_shipping_init', function () {
    $settings = EYHelper::settings();
    if (($settings['rate_on_add_to_cart'] == 1 && isset($_REQUEST['wc-ajax']) && $_REQUEST['wc-ajax'] === 'add_to_cart') || EYHelper::is_woo()) {
        enviaya_shipping_init();
    }
}); */

/* add_action('woocommerce_shipping_init', function () {
    $settings = EYHelper::settings();
    if (EYHelper::is_woo()) {
        enviaya_shipping_init();
    }
}); */

add_action('woocommerce_shipping_init', "enviaya_shipping_init");
