/*===================================
=            Global Vars            =
===================================*/
var $ = jQuery;
var pathname;
var full_url;
var isMenuOpen = false;
var isModalContacto = false;
var scrollYValue = 0;
gsap.registerPlugin(DrawSVGPlugin);
var openModalTallas = false;

var mobile1059 = window.matchMedia("(max-width: 1059px)");
var mobile699 = window.matchMedia("(max-width: 699px)");
// Calcula el tamaño de pantalla mobile
let vh = window.innerHeight * 0.01;
document.documentElement.style.setProperty('--vh', `${vh}px`);
// Agrega en style  height: calc(var(--vh, 1vh) * 100);
let vhModal = window.innerHeight * 0.01;
document.documentElement.style.setProperty('--vhModal', `${vhModal}px`);

/*====================================================
=            Inits or Functions Excecutes            =
====================================================*/

$(document).ready(function () {
    /*----------  Pathname and Full Url  ----------*/
    pathname = window.location.pathname; // Returns path only
    full_url = window.location.href; // Returns full URL



});

$(document).on('click', '.plus', function () {
    $input = $(this).prev('.qty');
    $max = $input.attr('max');
    var val = parseInt($input.val());
    var step = $input.attr('step');
    step = 'undefined' !== typeof (step) ? parseInt(step) : 1;
    $input.val(((val + step) > $max) ? $max : val + step).change();
});

$(document).on('click', '.minus', function (e) {
    $input = $(this).next('.qty');
    var val = parseInt($input.val());
    var step = $input.attr('step');
    step = 'undefined' !== typeof (step) ? parseInt(step) : 1;
    if (val > 1) {
        $input.val(val - step).change();
    }
});


$(window).load(function () {
    if (mobile1059.matches) {
        playHeart()
    }
});

const animacionMenu = gsap.timeline();
animacionMenu.to('#modal-menu', {
    duration: 0.001,
    opacity: 1,
    zIndex: 40
}).to('#modal-menu', {
    duration: 0.6,
    y: 0
}).reverse();

const animacionModalContacto = gsap.timeline();
animacionModalContacto.to('#modal-contacto', {
    duration: 0.001,
    opacity: 1,
    zIndex: 60
}).to('#modal-contacto', {
    duration: 0.6,
    y: 0
}).reverse();

$('[data-modalMenu]').on('click', function (e) {
    e.preventDefault();
    animacionMenu.reversed(!animacionMenu.reversed())
    if (isMenuOpen) {
        isMenuOpen = false
        $('[data-modalMenu] span').empty()
        $('[data-modalMenu] span').html('menú')
    } else {
        isMenuOpen = true;
        scrollYValue = window.scrollY
        $('[data-modalMenu] span').empty()
        $('[data-modalMenu] span').html('cerrar')
    }
})

$('[data-modalContacto]').on('click', function (e) {
    e.preventDefault();
    animacionModalContacto.reversed(!animacionModalContacto.reversed());
    if (isModalContacto) {
        isModalContacto = false;
    } else {
        isModalContacto = true;
        scrollYValue = window.scrollY;
    }
})

window.addEventListener("resize", function () {
    vhModal = window.innerHeight * 0.01;
    document.documentElement.style.setProperty('--vhModal', `${vhModal}px`);
})

$(document).scroll(function () {
    if (isMenuOpen || isModalContacto) {
        window.scrollTo(0, scrollYValue);
    }
})


// var x, i, j, selElmnt, a, b, c;
// /*look for any elements with the class "contenedor-select":*/
// x = document.getElementsByClassName("custom-select");
// for (i = 0; i < x.length; i++) {
//   selElmnt = x[i].getElementsByTagName("select")[0];
//   // var option = selElmnt.options;
//   // console.log(option);
//   /*for each element, create a new DIV that will act as the selected item:*/
//   a = document.createElement("DIV");
//   a.setAttribute("class", "select-selected");
//   a.innerHTML = selElmnt.options[selElmnt.selectedIndex].innerHTML;
//   x[i].appendChild(a);
//   /*for each element, create a new DIV that will contain the option list:*/
//   b = document.createElement("DIV");
//   b.setAttribute("class", "select-items select-hide");
//   for (j = 0; j < selElmnt.length; j++) {
//     /*for each option in the original select element,
//     create a new DIV that will act as an option item:*/
//     c = document.createElement("DIV");
//     if (j === 0) {
//       c.setAttribute("class", "same-as-selected");
//     }
//     c.innerHTML = selElmnt.options[j].innerHTML;
//     c.addEventListener("click", function (e) {
//       /*when an item is clicked, update the original select box,
//       and the selected item:*/
//       var y, i, k, s, h;
//       s = this.parentNode.parentNode.getElementsByTagName("select")[0];
//       h = this.parentNode.previousSibling;
//       for (i = 0; i < s.length; i++) {
//         //en base al valor que se muestra en el option esta ligado al div que se crea
//         //con este codigo recorre el select y compara hasta encontrar que el valor en el que
//         //hicieron click sea igual al del select
//         if (s.options[i].innerHTML == this.innerHTML) {
//           s.selectedIndex = i;
//           h.innerHTML = this.innerHTML;
//           var filter = s.value;
//           y = this.parentNode.getElementsByClassName("same-as-selected");
//           for (k = 0; k < y.length; k++) {
//             // y[k].removeAttribute("class");
//             $(y[k]).removeClass("same-as-selected");
//           }
//           // this.setAttribute("class", "same-as-selected");
//           $(this).addClass("same-as-selected");
//           if (s.name == "filterAmenidadesGaleria") {
//             obtieneCategoryMovilAmenidades(filter);
//           } 
//           break;
//         }
//       }
//       h.click();
//     });
//     b.appendChild(c);
//   }
//   x[i].appendChild(b);
//   a.addEventListener("click", function (e) {
//     /*when the select box is clicked, close any other select boxes,
//     and open/close the current select box:*/
//     e.stopPropagation();
//     closeAllSelect(this);
//     this.nextSibling.classList.toggle("select-hide");
//     this.classList.toggle("select-arrow-active");
//   });
// }

// function closeAllSelect(elmnt) {
//   /*a function that will close all select boxes in the document,
//   except the current select box:*/
//   var x, y, i, arrNo = [];
//   x = document.getElementsByClassName("select-items");
//   y = document.getElementsByClassName("select-selected");
//   for (i = 0; i < y.length; i++) {
//     if (elmnt == y[i]) {
//       arrNo.push(i)
//     } else {
//       y[i].classList.remove("select-arrow-active");
//     }
//   }
//   for (i = 0; i < x.length; i++) {
//     if (arrNo.indexOf(i)) {
//       x[i].classList.add("select-hide");
//     }
//   }
// }
// /*if the user clicks anywhere outside the select box,
// then close all select boxes:*/
// document.addEventListener("click", closeAllSelect);



$('.openModalTallas').click(function (e) {
    e.preventDefault();
    var modalTallas = $('.modal-tallas');
    if (!openModalTallas) {
        TweenMax.set("html", { "overflow-y": "hidden" });
        TweenMax.set(modalTallas, { zIndex: 9999 });
        TweenMax.to(modalTallas, 0.6, {
            opacity: 1, onComplete: () => {
                openModalTallas = true;
            }
        });
    } else {
        var tl = new TimelineMax();
        tl.set("html", { "overflow-y": "auto" });
        tl.to(modalTallas, 0.25, { opacity: 0 });
        tl.set(modalTallas, {
            zIndex: -1, onComplete: () => {
                openModalTallas = false;
            }
        });
    }
});

function getFormData($form) {
    var unindexed_array = $form.serializeArray();
    var indexed_array = {};

    $.map(unindexed_array, function (n, i) {
        indexed_array[n['name']] = n['value'];
    });

    return indexed_array;
}